### `README.md`

# FLAME


## Installation

Clone the repo and install dependencies:

```sh
pip install -e .
```

## Usage

### Training
Train the FLAME model on seqCIFAR-10/100:

```sh
train -device cuda:0 -data-dir ./data -out-dir ./logs -epochs 64 -b 128 -opt adam -class-num 10
```

### Evaluation
Evaluate the model:

```sh
evaluate --model-path ./logs/best_checkpoint.pth --data-dir ./data --class-num 10
```

### Visualization
Plot metrics or visualize model predictions:

```sh
visualize --mode loss_accuracy --log-dir ./logs/tensorboard
```
For predictions visualization:
```sh
visualize --mode predictions --model-path ./logs/best_checkpoint.pth --data-dir ./data --num-images 16
```

## Configuration

Modify hyperparameters in `configs/default_config.yaml` to customize training:

```yaml
training:
  batch_size: 128
  epochs: 64
  learning_rate: 0.001
dataset:
  data_dir: "./data"
  num_workers: 4
augmentation:
  random_flip: True
  normalization:
    mean: [0.4914, 0.4822, 0.4465]
```

## Folder Structure

```
splr_model/
├── datasets/              # CIFAR-10/100 loaders
├── models/                # FLAME model
├── scripts/               # Training, evaluation, visualization scripts
├── utils/                 # Data utilities and augmentations
├── configs/               # Default config file
├── README.md              # Project documentation
├── setup.py               # Setup script
└── requirements.txt       # Required packages
```
